import jieba;
import os;
class spamEmailBayes:
    #获得停用词表
    def getStopWords(self):
        #self，表示创建的类实例本身,当成this来看
        #暂时储存停用词表内容
        stopList=[]
        for line in open("../data/中文停用词表.txt"):
            #打开文件 fo = open("foo.txt", "wb")
            stopList.append(line[:len(line)-1])
            '''
            append()方法用于在列表末尾添加新的对象
            字符串正向递增序号 0，1，2，3，，，N
            <字符串>[M: N]，M缺失表示至开头，N缺失表示至结尾；
            '''
        return stopList;
    
    #获得词典
    def get_word_list(self,content,wordsList,stopList):
        #分词结果放入res_list
        res_list = list(jieba.cut(content))
        #list1 = ['physics', 'chemistry', 1997, 2000]
        for i in res_list:
            #print("列表分割后的字段i：{}".format(i))
            if i not in stopList and i.strip()!='-' and i!=None:        
                if i not in wordsList:
                    #print("丰富词典，本次录入字段：{}".format(i))
                    wordsList.append(i)
        #print("词典：")
        #print(res_list)
                    
    #若列表中的词已在词典中，则加1，否则添加进去
    def addToDict(self,wordsList,wordsDict):
        for item in wordsList:
            if item in wordsDict.keys():
                #计数数组wordsDict对应词典数组wordsList
                wordsDict[item]+=1
            else:
                wordsDict.setdefault(item,1)
                            
    def get_File_List(self,filePath):
        filenames=os.listdir(filePath)
        '''
        os.listdir() 方法用于返回指定的文件夹
        包含的文件或文件夹的名字的列表。
        这个列表以字母顺序。 
        它不包括 '.' 和'..' 即使它在文件夹中。
        '''
        return filenames
    
    #通过计算每个文件中p(s|w)来得到对分类影响最大的15个词
    #实际使用时不仅仅用15个词，而是全部。
    def getTestWords(self,testDict,spamDict,normDict,normFilelen,spamFilelen):
        wordProbList={}
        #print("这次的spamDict:")
        #print(spamDict)
        for word,num  in testDict.items():
        #word:所有测试邮件中出现过的词，num:测试邮件中出现该词在的份数
            if word in spamDict.keys() and word in normDict.keys():
                pw_s=spamDict[word]/spamFilelen
                #print(str(spamFilelen)+"封是；同时存在"+word+str(spamDict[word]))
                #spamFilelen：垃圾邮件总个数
                #spamDict[word]:word词出现过的垃圾邮件份数
                #pw_s 这样看 p(w|s)
                #pw_s:某个词在垃圾邮件中的比率
                pw_n=normDict[word]/normFilelen
                #出现这个词的非垃圾邮件在总非垃圾邮件中的比率
                ps_w=pw_s/(pw_s+pw_n)
                #ps_w 代表这个word下是垃圾邮件的概率
                wordProbList.setdefault(word,ps_w)
                #Python 字典 setdefault() 函数和 get()方法 类似, 
                #如果键不存在于字典中，将会添加键并将值设为默认值。
            if word in spamDict.keys() and word not in normDict.keys():
                #print("只存在垃圾邮件中的，"+word+str(spamDict[word]))
                pw_s=spamDict[word]/spamFilelen
                pw_n=0.01
                ps_w=pw_s/(pw_s+pw_n)
                #ps_w就表示有词时是垃圾邮件的概率
                wordProbList.setdefault(word,ps_w)
            if word not in spamDict.keys() and word in normDict.keys():
                pw_s=0.01
                pw_n=normDict[word]/normFilelen
                #print(str(normFilelen)+"只存在非垃圾邮件中的，"+word+str(spamDict[word]))
                ps_w=pw_s/(pw_s+pw_n) 
                wordProbList.setdefault(word,ps_w)
            if word not in spamDict.keys() and word not in normDict.keys():
                #若该词不在脏词词典中，概率设为0.4
                wordProbList.setdefault(word,0.47)
        #这里做的几个假设基于前人做的一些研究工作得出的。修改试试？
        #print("sorted之前的键值对：")
        #print(wordProbList)
        #换一种排序方式
        #wordProbList=
        sorted(wordProbList.items(),key=lambda d:d[1],reverse=True)[0:15]
        #疑惑，b = sorted(a)应当不改变a才对。修改试试。      
        #wordProbList=dict(wordProbList)
        #print("十五个词降序表")
        #print(wordProbList)
        #选出对垃圾邮件的15个特征，包括单词以及对应概率
        return (wordProbList)
    
    #求特征向量可能有问题
    
    #计算贝叶斯概率
    def calBayes(self,wordProbList,spamdict,normdict,spamFilelen,normFilelen):
        ps_w=1
        ps_n=1
        #初始化
        '''
        #prob 在这里没有用？
        #print("换行")
        for word,prob in wordProbList.items():
            #查看单词及对应概率
            #print(word+"/"+str(prob))
            #print(prob)
            if word in spamdict.keys():
                pw_s*=spamdict[word]/spamFilelen
            else:
                pw_s*=0.01     
            #if word in normdict.keys():   
            #    pn_s*=(1-normdict[word]/normFilelen)
            #else:
            #    pn_s*=0.01
            if word in normdict.keys() and word in spamdict.keys():
                pw*=(spamdict[word]+normdict[word])/(spamFilelen+normFilelen)
            elif word not in spamdict.keys() and word in normdict.keys() :
                pw*=normdict[word]/(spamFilelen+normFilelen)
            elif word in spamdict.keys() and word not in normdict.keys():
                pw*=spamdict[word]/(spamFilelen+normFilelen)
            else:
                pw*=0.01
            ps=spamFilelen/(spamFilelen+normFilelen)    
        '''
        for word,prob in wordProbList.items() :
            #print(word+"/"+str(prob))
            ps_w*=(prob)
            ps_n*=(1-prob)
        p=ps_w/(ps_w+ps_n)
        #p=pw_s/pw*ps
        #print(str(ps_w)+"////"+str(ps_n))
        #return ps_w
        return p        

    #计算预测结果正确率
    def calAccuracy(self,testResult):
        rightCount=0
        errorCount=0
        for name ,catagory in testResult.items():
            if (int(name)<1000 and catagory==0) or(int(name)>1000 and catagory==1):
                rightCount+=1
            else:
                errorCount+=1
        return rightCount/(rightCount+errorCount)

  #返回准确率，召回率，F1分数
    def getPrecisionRecallF1(self,testResult):
        #T、F预测正确与否，P、N预测的lable
        #文件名作为lable,低于1000的是非垃圾邮件
        TPCount=0
        TNCount=0
        FPCount=0
        FNCount=0
        for name ,catagory in testResult.items():
            if (int(name)<1000 and catagory==0):
                TNCount+=1
            elif (int(name)<1000 and catagory==1):
                FNCount+=1
            elif (int(name)>1000 and catagory==0):
                FPCount+=1
            elif (int(name)>1000 and catagory==1):
                TPCount+=1
            else:
                print("")
        print("混淆矩阵TP,TN,FP,FN:")
        print(TPCount,TNCount,FPCount,FNCount)
        if((TPCount+FPCount)==0):
            precision=0
        else:
            precision=TPCount/(TPCount+FPCount)

        #假正例率FPR=FP/(FP+TN)
        if((FPCount+TNCount)==0):
            FPR=0
        else:
            FPR=FPCount/(FPCount+TNCount)
        #真正例率TPR=TP/(TP+FN)
        if((TPCount+FNCount)==0):
            recall=0
        else:
            recall=TPCount/(TPCount+FNCount)
        if((precision+recall) ==0):
            F1=0
        else:
            F1=2*precision*recall/(precision+recall) 
        return precision,recall,F1,FPR